/*
 * Decompiled with CFR 0.152.
 */
package net.nooj4nlp.engine;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Stack;
import net.nooj4nlp.engine.GramType;
import net.nooj4nlp.engine.Language;
import net.nooj4nlp.engine.MTrace;
import net.nooj4nlp.engine.RefObject;
import net.nooj4nlp.engine.State;
import net.nooj4nlp.engine.helper.ParameterCheck;

public class Gram
implements Serializable {
    private static final long serialVersionUID = 1544877445200128280L;
    public ArrayList<State> states = new ArrayList();
    ArrayList<Boolean> isTerminal;
    ArrayList<String> vocab;
    transient String[] InflectionsCommands;

    Gram(int nbOfStates) {
        for (int i = 0; i < nbOfStates; ++i) {
            this.states.add(new State());
        }
        this.vocab = null;
        this.InflectionsCommands = null;
    }

    Gram() {
        this.vocab = null;
        this.InflectionsCommands = null;
    }

    private void cleanup() {
        for (State st : this.states) {
            st.AllIdLabels = null;
        }
    }

    final void addTransition(int src, int dst, String label, ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        int idLabel;
        ParameterCheck.mandatoryString("label", label);
        ParameterCheck.mandatoryCollection("aVocab", aVocab);
        if (hVocab.containsKey(label)) {
            idLabel = hVocab.get(label);
        } else {
            aVocab.add(label);
            idLabel = aVocab.size() - 1;
            hVocab.put(label, idLabel);
        }
        this.states.get(src).addTrans(dst, idLabel);
    }

    static Gram addOutput(Gram grm1, String labelOutput, ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        int idLabel;
        ParameterCheck.mandatory("grm1", grm1);
        ParameterCheck.mandatoryString("labelOutput", labelOutput);
        ParameterCheck.mandatoryCollection("aVocab", aVocab);
        Gram grmOut = new Gram(2);
        String label = "<E>/" + labelOutput;
        if (hVocab.containsKey(label)) {
            idLabel = hVocab.get(label);
        } else {
            aVocab.add(label);
            idLabel = aVocab.size() - 1;
            hVocab.put(label, idLabel);
        }
        grmOut.states.get(0).addTrans(1, idLabel);
        return grmOut.concatenation(grm1);
    }

    final void addTransition(int src, int dst, int idLabel) {
        this.states.get(src).addTrans(dst, idLabel);
    }

    final void transfer(Gram grm1, int anchor, int inode) {
        ParameterCheck.mandatory("grm1", grm1);
        for (int istate = 0; istate < grm1.states.size(); ++istate) {
            State st = grm1.states.get(istate);
            int nst = istate + anchor;
            for (int itrans = 0; itrans < st.Dests.size(); ++itrans) {
                int dst = st.Dests.get(itrans);
                int idl = st.IdLabels.get(itrans);
                int ndst = dst + anchor;
                this.states.get(nst).addTrans(ndst, idl);
                this.states.get((int)nst).GraphNodeNumber = inode;
            }
        }
    }

    static Gram token(String token, ArrayList<String> aVocab, HashMap<String, Integer> hVocab) {
        ParameterCheck.mandatoryString("token", token);
        ParameterCheck.mandatoryCollection("aVocab", aVocab);
        Gram grm = new Gram(2);
        grm.addTransition(0, 1, token, aVocab, hVocab);
        return grm;
    }

    final Gram concatenation(Gram grm2) {
        int dst;
        int itrans;
        State st;
        ParameterCheck.mandatory("grm2", grm2);
        int grm1InitialNbOfStates = this.states.size();
        this.states.add(0, new State());
        this.states.add(0, new State());
        for (int istate = 2; istate < this.states.size(); ++istate) {
            st = this.states.get(istate);
            for (int itrans2 = 0; itrans2 < st.Dests.size(); ++itrans2) {
                int dst2 = st.Dests.get(itrans2);
                st.Dests.set(itrans2, dst2 + 2);
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                for (itrans = 0; itrans < outgoingTransitions.size(); ++itrans) {
                    dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + 2);
                }
            }
        }
        for (int i = 0; i < grm2.states.size(); ++i) {
            st = grm2.states.get(i);
            for (int itrans3 = 0; itrans3 < st.Dests.size(); ++itrans3) {
                int dst3 = st.Dests.get(itrans3);
                int ndst = dst3 + grm1InitialNbOfStates + 2;
                st.Dests.set(itrans3, ndst);
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                for (itrans = 0; itrans < outgoingTransitions.size(); ++itrans) {
                    dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + grm1InitialNbOfStates + 2);
                }
            }
            this.states.add(st);
        }
        this.states.get(0).addTrans(2, 0);
        this.states.get(3).addTrans(grm1InitialNbOfStates + 2, 0);
        this.states.get(grm1InitialNbOfStates + 3).addTrans(1, 0);
        return this;
    }

    final Gram disjunction(Gram grm2) {
        int dst;
        int itrans;
        State st;
        ParameterCheck.mandatory("grm2", grm2);
        int grm1InitialNbOfStates = this.states.size();
        this.states.add(0, new State());
        this.states.add(0, new State());
        for (int istate = 2; istate < this.states.size(); ++istate) {
            st = this.states.get(istate);
            for (int itrans2 = 0; itrans2 < st.Dests.size(); ++itrans2) {
                int dst2 = st.Dests.get(itrans2);
                st.Dests.set(itrans2, dst2 + 2);
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                for (itrans = 0; itrans < outgoingTransitions.size(); ++itrans) {
                    dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + 2);
                }
            }
        }
        for (int i = 0; i < grm2.states.size(); ++i) {
            st = grm2.states.get(i);
            for (int itrans3 = 0; itrans3 < st.Dests.size(); ++itrans3) {
                int dst3 = st.Dests.get(itrans3);
                int ndst = dst3 + grm1InitialNbOfStates + 2;
                st.Dests.set(itrans3, ndst);
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                for (itrans = 0; itrans < outgoingTransitions.size(); ++itrans) {
                    dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + grm1InitialNbOfStates + 2);
                }
            }
            this.states.add(st);
        }
        this.states.get(0).addTrans(2, 0);
        this.states.get(0).addTrans(grm1InitialNbOfStates + 2, 0);
        this.states.get(3).addTrans(1, 0);
        this.states.get(grm1InitialNbOfStates + 3).addTrans(1, 0);
        return this;
    }

    final Gram disjunctions(ArrayList<Gram> grms2) {
        ParameterCheck.mandatoryCollection("grms2", grms2);
        this.states.add(0, new State());
        this.states.add(0, new State());
        for (int istate = 2; istate < this.states.size(); ++istate) {
            State st = this.states.get(istate);
            for (int itrans = 0; itrans < st.Dests.size(); ++itrans) {
                int dst = st.Dests.get(itrans);
                st.Dests.set(itrans, dst + 2);
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                for (int itrans = 0; itrans < outgoingTransitions.size(); ++itrans) {
                    int dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + 2);
                }
            }
        }
        this.states.get(0).addTrans(2, 0);
        this.states.get(3).addTrans(1, 0);
        for (Gram grm2 : grms2) {
            int anchorStNb = this.states.size();
            for (int i = 0; i < grm2.states.size(); ++i) {
                State st = grm2.states.get(i);
                for (int itrans = 0; itrans < st.Dests.size(); ++itrans) {
                    int dst = st.Dests.get(itrans);
                    int ndst = dst + anchorStNb;
                    st.Dests.set(itrans, ndst);
                }
                for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                    for (int itrans = 0; itrans < outgoingTransitions.size(); ++itrans) {
                        int dst = outgoingTransitions.get(itrans);
                        outgoingTransitions.set(itrans, dst + anchorStNb);
                    }
                }
                this.states.add(st);
            }
            this.states.get(0).addTrans(anchorStNb, 0);
            this.states.get(anchorStNb + 1).addTrans(1, 0);
        }
        return this;
    }

    final Gram concatenations(ArrayList<Gram> grms2) {
        this.states.add(0, new State());
        this.states.add(0, new State());
        for (int istate = 2; istate < this.states.size(); ++istate) {
            State st = this.states.get(istate);
            for (int itrans = 0; itrans < st.Dests.size(); ++itrans) {
                int n = st.Dests.get(itrans);
                st.Dests.set(itrans, n + 2);
            }
            for (ArrayList arrayList : st.AllIdLabels.values()) {
                for (int itrans = 0; itrans < arrayList.size(); ++itrans) {
                    int dst = (Integer)arrayList.get(itrans);
                    arrayList.set(itrans, dst + 2);
                }
            }
        }
        int previousTerminalNode = 3;
        this.states.get(0).addTrans(2, 0);
        int anchorStNb = this.states.size();
        for (Gram gram : grms2) {
            anchorStNb = this.states.size();
            for (int i = 0; i < gram.states.size(); ++i) {
                State st = gram.states.get(i);
                for (int itrans = 0; itrans < st.Dests.size(); ++itrans) {
                    int dst = st.Dests.get(itrans);
                    int ndst = dst + anchorStNb;
                    st.Dests.set(itrans, ndst);
                }
                for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                    for (int itrans = 0; itrans < outgoingTransitions.size(); ++itrans) {
                        int dst = outgoingTransitions.get(itrans);
                        outgoingTransitions.set(itrans, dst + anchorStNb);
                    }
                }
                this.states.add(st);
            }
            this.states.get(previousTerminalNode).addTrans(anchorStNb, 0);
            previousTerminalNode = anchorStNb + 1;
        }
        this.states.get(anchorStNb + 1).addTrans(1, 0);
        return this;
    }

    final Gram kleene() {
        this.states.add(0, new State());
        for (int istate = 2; istate < this.states.size(); ++istate) {
            State st = this.states.get(istate);
            for (int itrans = 0; itrans < st.Dests.size(); ++itrans) {
                int dst = st.Dests.get(itrans);
                st.Dests.set(itrans, dst + 2);
            }
            for (ArrayList<Integer> outgoingTransitions : st.AllIdLabels.values()) {
                for (int itrans = 0; itrans < outgoingTransitions.size(); ++itrans) {
                    int dst = outgoingTransitions.get(itrans);
                    outgoingTransitions.set(itrans, dst + 2);
                }
            }
        }
        this.states.get(0).addTrans(1, 0);
        this.states.get(2).addTrans(1, 0);
        this.states.get(0).addTrans(2, 0);
        return this;
    }

    public final String prepareVocabIn(int pos) {
        int i;
        String label = this.vocab.get(pos);
        for (i = 0; i < label.length() && label.charAt(i) != '/'; ++i) {
            if (label.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (label.charAt(i) != '\"') continue;
            ++i;
            while (i < label.length() && label.charAt(i) != '\"') {
                ++i;
            }
        }
        if (i < label.length()) {
            String input = label.substring(0, i);
            return input;
        }
        return label;
    }

    public final String prepareVocabOut(int pos) {
        int i;
        String label = this.vocab.get(pos);
        for (i = 0; i < label.length() && label.charAt(i) != '/'; ++i) {
            if (label.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (label.charAt(i) != '\"') continue;
            ++i;
            while (i < label.length() && label.charAt(i) != '\"') {
                ++i;
            }
        }
        if (i < label.length()) {
            String output = label.substring(i + 1);
            return output;
        }
        return null;
    }

    private final int lookForVariable(String varName) {
        ParameterCheck.mandatoryString("varName", varName);
        for (int istate = 0; istate < this.states.size(); ++istate) {
            State state = this.states.get(istate);
            for (int itrans = 0; itrans < state.Dests.size(); ++itrans) {
                int lbl = state.IdLabels.get(itrans);
                String ilabel0 = this.prepareVocabIn(lbl);
                if (!ilabel0.equals("$(" + varName)) continue;
                return istate;
            }
        }
        return -1;
    }

    private final void exploreForVariable(int initialState, int stateNb, String varName, int recLevel, RefObject<Gram> resGram) {
        ParameterCheck.mandatoryString("varName", varName);
        State state = this.states.get(stateNb);
        for (int itrans = 0; itrans < state.Dests.size(); ++itrans) {
            int iNewState;
            int dst = state.Dests.get(itrans);
            int lbl = state.IdLabels.get(itrans);
            if (dst == 1) {
                ((Gram)resGram.argvalue).addTransition(initialState, 1, lbl);
            }
            String ilabel0 = this.prepareVocabIn(lbl);
            if (recLevel == 0) {
                if (!ilabel0.equals("$(" + varName)) continue;
                ((Gram)resGram.argvalue).states.add(new State());
                iNewState = ((Gram)resGram.argvalue).states.size() - 1;
                ((Gram)resGram.argvalue).addTransition(initialState, iNewState, 0);
                this.exploreForVariable(iNewState, dst, varName, recLevel + 1, resGram);
                continue;
            }
            if (ilabel0.length() >= 2 && ilabel0.substring(0, 2).equals("$(")) {
                ((Gram)resGram.argvalue).states.add(new State());
                iNewState = ((Gram)resGram.argvalue).states.size() - 1;
                ((Gram)resGram.argvalue).addTransition(initialState, iNewState, lbl);
                this.exploreForVariable(iNewState, dst, varName, recLevel + 1, resGram);
                continue;
            }
            if (ilabel0.length() >= 2 && ilabel0.substring(0, 2).equals("$)")) {
                if (recLevel <= 1) {
                    ((Gram)resGram.argvalue).addTransition(initialState, 1, 0);
                    continue;
                }
                ((Gram)resGram.argvalue).states.add(new State());
                iNewState = ((Gram)resGram.argvalue).states.size() - 1;
                ((Gram)resGram.argvalue).addTransition(initialState, iNewState, lbl);
                this.exploreForVariable(iNewState, dst, varName, recLevel - 1, resGram);
                continue;
            }
            ((Gram)resGram.argvalue).states.add(new State());
            iNewState = ((Gram)resGram.argvalue).states.size() - 1;
            ((Gram)resGram.argvalue).addTransition(initialState, iNewState, lbl);
            this.exploreForVariable(iNewState, dst, varName, recLevel, resGram);
        }
    }

    final Gram getGramFromVariableDefinition(String varName) {
        ParameterCheck.mandatoryString("varName", varName);
        int iStateVar = this.lookForVariable(varName);
        if (iStateVar == -1) {
            return null;
        }
        Gram resgram = new Gram();
        resgram.states.add(new State());
        resgram.states.add(new State());
        RefObject<Gram> tempRef_resgram = new RefObject<Gram>(resgram);
        this.exploreForVariable(0, iStateVar, varName, 0, tempRef_resgram);
        resgram = (Gram)tempRef_resgram.argvalue;
        resgram.vocab = this.vocab;
        resgram.isTerminal = new ArrayList();
        for (int i = 0; i < resgram.states.size(); ++i) {
            resgram.isTerminal.add(false);
        }
        resgram.isTerminal.set(1, true);
        return resgram;
    }

    private static int argnum(String commands, int ic) {
        ParameterCheck.mandatoryString("commands", commands);
        if (commands.charAt(ic) == '>') {
            return 1;
        }
        if (commands.charAt(ic) == 'W' && commands.charAt(ic + 1) == '>') {
            return -1;
        }
        int val = 0;
        while (ic < commands.length() && commands.charAt(ic) != '>') {
            if (!Character.isDigit(commands.charAt(ic))) {
                return 0;
            }
            val = val * 10 + commands.charAt(ic) - 48;
            ++ic;
        }
        return val;
    }

    public static String processInflection(Language lan, String lemma, String commands, RefObject<Integer> ires) {
        StringBuilder res = new StringBuilder(lemma);
        ires.argvalue = res.length();
        int ic = 0;
        while (ic < commands.length()) {
            Object object;
            Integer n;
            Object object2;
            if (commands.charAt(ic) == '\\') {
                res.insert((int)((Integer)ires.argvalue), String.valueOf(commands.charAt(ic + 1)));
                RefObject<Integer> refObject = ires;
                Integer n2 = (Integer)refObject.argvalue;
                refObject.argvalue = (Integer)refObject.argvalue + 1;
                Integer n3 = refObject.argvalue;
                ic += 2;
                continue;
            }
            if (commands.charAt(ic) == '\"') {
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '\"') {
                    res.insert((int)((Integer)ires.argvalue), String.valueOf(commands.charAt(ic)));
                    RefObject<Integer> refObject = ires;
                    Integer n4 = (Integer)refObject.argvalue;
                    refObject.argvalue = (Integer)refObject.argvalue + 1;
                    Integer n5 = refObject.argvalue;
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic) != '<') {
                res.insert((int)((Integer)ires.argvalue), String.valueOf(commands.charAt(ic)));
                RefObject<Integer> refObject = ires;
                Integer n6 = (Integer)refObject.argvalue;
                refObject.argvalue = (Integer)refObject.argvalue + 1;
                Integer n7 = refObject.argvalue;
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'B') {
                int val = Gram.argnum(commands, ic + 2);
                if (val == -1) {
                    val = (Integer)ires.argvalue;
                } else {
                    if (val == 0) {
                        res.insert((int)((Integer)ires.argvalue), "<B:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                    if ((Integer)ires.argvalue - val < 0) {
                        res.insert((int)((Integer)ires.argvalue), "<B:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                }
                RefObject<Integer> refObject = ires;
                Integer.valueOf((Integer)refObject.argvalue - val);
                refObject.argvalue = refObject.argvalue;
                res.delete((Integer)ires.argvalue, (Integer)ires.argvalue + val);
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'C') {
                int val = Gram.argnum(commands, ic + 2);
                if (val != 1) {
                    res.insert((int)((Integer)ires.argvalue), "<C:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                if (Character.isUpperCase(res.charAt((Integer)ires.argvalue - 1))) {
                    res.setCharAt((Integer)ires.argvalue - 1, Character.toLowerCase(res.charAt((Integer)ires.argvalue - 1)));
                } else if (Character.isLowerCase(res.charAt((Integer)ires.argvalue - 1))) {
                    res.setCharAt((Integer)ires.argvalue - 1, Character.toUpperCase(res.charAt((Integer)ires.argvalue - 1)));
                }
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'D') {
                int val = Gram.argnum(commands, ic + 2);
                if (val == 0 || val == -1 || (Integer)ires.argvalue - val < 0) {
                    res.insert((int)((Integer)ires.argvalue), "<D:ERROR=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                if (lan.isoName.equals("br") || lan.isoName.equals("hu")) {
                    if (commands.charAt(ic + 1) == '\u00c1') {
                        if ((Integer)ires.argvalue - 1 < 0) {
                            ires.argvalue = -1;
                        }
                        if (res.charAt((Integer)ires.argvalue - 1) == 'a') {
                            res.setCharAt((Integer)ires.argvalue - 1, '\u00e1');
                        } else if (res.charAt((Integer)ires.argvalue - 1) == 'e') {
                            res.setCharAt((Integer)ires.argvalue - 1, '\u00e9');
                        }
                    } else if (commands.charAt(ic + 1) == 'D') {
                        if ((Integer)ires.argvalue - 1 < 0) {
                            ires.argvalue = -1;
                        }
                        if (res.charAt((Integer)ires.argvalue - 1) != 'b' || (Integer)ires.argvalue < 2 || res.charAt((Integer)ires.argvalue - 2) != res.charAt((Integer)ires.argvalue - 1)) {
                            if (res.charAt((Integer)ires.argvalue - 1) == 'a' || res.charAt((Integer)ires.argvalue - 1) == '\u00e1') {
                                res.setCharAt((Integer)ires.argvalue - 1, '\u00e1');
                                res.insert((int)((Integer)ires.argvalue), "v");
                                RefObject<Integer> refObject = ires;
                                Integer n8 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 1) == 'e' || res.charAt((Integer)ires.argvalue - 1) == '\u00e9') {
                                res.setCharAt((Integer)ires.argvalue - 1, '\u00e9');
                                res.insert((int)((Integer)ires.argvalue), "v");
                                RefObject<Integer> refObject = ires;
                                Integer n9 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 1) == 'x') {
                                res.setCharAt((Integer)ires.argvalue - 1, 'x');
                                res.insert((int)((Integer)ires.argvalue), "s");
                                RefObject<Integer> refObject = ires;
                                Integer n10 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                                res.insert((int)((Integer)ires.argvalue), "z");
                                refObject = ires;
                                n10 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 1) == 'i' || res.charAt((Integer)ires.argvalue - 1) == '\u00ed' || res.charAt((Integer)ires.argvalue - 1) == 'o' || res.charAt((Integer)ires.argvalue - 1) == '\u00f3' || res.charAt((Integer)ires.argvalue - 1) == '\u00f6' || res.charAt((Integer)ires.argvalue - 1) == '\u0151' || res.charAt((Integer)ires.argvalue - 1) == 'u' || res.charAt((Integer)ires.argvalue - 1) == '\u00fa' || res.charAt((Integer)ires.argvalue - 1) == '\u00fc' || res.charAt((Integer)ires.argvalue - 1) == '\u0171') {
                                res.insert((int)((Integer)ires.argvalue), "v");
                                RefObject<Integer> refObject = ires;
                                Integer n11 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (!((Integer)ires.argvalue < 3 || res.charAt((Integer)ires.argvalue - 3) == 'c' && res.charAt((Integer)ires.argvalue - 2) == 'c' && res.charAt((Integer)ires.argvalue - 1) == 's' || res.charAt((Integer)ires.argvalue - 3) == 'g' && res.charAt((Integer)ires.argvalue - 2) == 'g' && res.charAt((Integer)ires.argvalue - 1) == 'y' || res.charAt((Integer)ires.argvalue - 3) == 'l' && res.charAt((Integer)ires.argvalue - 2) == 'l' && res.charAt((Integer)ires.argvalue - 1) == 'y' || res.charAt((Integer)ires.argvalue - 3) == 'n' && res.charAt((Integer)ires.argvalue - 2) == 'n' && res.charAt((Integer)ires.argvalue - 1) == 'y' || res.charAt((Integer)ires.argvalue - 3) == 't' && res.charAt((Integer)ires.argvalue - 2) == 't' && res.charAt((Integer)ires.argvalue - 1) == 'y' || res.charAt((Integer)ires.argvalue - 3) == 's' && res.charAt((Integer)ires.argvalue - 2) == 's' && res.charAt((Integer)ires.argvalue - 1) == 'z' || res.charAt((Integer)ires.argvalue - 3) == 'z' && res.charAt((Integer)ires.argvalue - 2) == 'z' && res.charAt((Integer)ires.argvalue - 1) == 's' || res.charAt((Integer)ires.argvalue - 3) != 'd' || res.charAt((Integer)ires.argvalue - 2) != 'z' || res.charAt((Integer)ires.argvalue - 1) != 's')) {
                                res.setCharAt((Integer)ires.argvalue - 2, 'd');
                                res.setCharAt((Integer)ires.argvalue - 1, 'z');
                                res.insert((int)((Integer)ires.argvalue), "s");
                                RefObject<Integer> refObject = ires;
                                Integer n12 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            }
                        }
                        if ((Integer)ires.argvalue >= 2) {
                            if (res.charAt((Integer)ires.argvalue - 2) == 'c' && res.charAt((Integer)ires.argvalue - 1) == 's') {
                                res.setCharAt((Integer)ires.argvalue - 1, 'c');
                                res.insert((int)((Integer)ires.argvalue), "s");
                                RefObject<Integer> refObject = ires;
                                Integer n13 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 2) == 'd' && res.charAt((Integer)ires.argvalue - 1) == 'z') {
                                res.setCharAt((Integer)ires.argvalue - 1, 'd');
                                res.insert((int)((Integer)ires.argvalue), "z");
                                RefObject<Integer> refObject = ires;
                                Integer n14 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 2) == 'g' && res.charAt((Integer)ires.argvalue - 1) == 'y') {
                                res.setCharAt((Integer)ires.argvalue - 1, 'g');
                                res.insert((int)((Integer)ires.argvalue), "y");
                                RefObject<Integer> refObject = ires;
                                Integer n15 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 2) == 'l' && res.charAt((Integer)ires.argvalue - 1) == 'y') {
                                res.setCharAt((Integer)ires.argvalue - 1, 'l');
                                res.insert((int)((Integer)ires.argvalue), "y");
                                RefObject<Integer> refObject = ires;
                                Integer n16 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 2) == 'n' && res.charAt((Integer)ires.argvalue - 1) == 'y') {
                                res.setCharAt((Integer)ires.argvalue - 1, 'n');
                                res.insert((int)((Integer)ires.argvalue), "y");
                                RefObject<Integer> refObject = ires;
                                Integer n17 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 2) == 's' && res.charAt((Integer)ires.argvalue - 1) == 'z') {
                                res.setCharAt((Integer)ires.argvalue - 1, 's');
                                res.insert((int)((Integer)ires.argvalue), "z");
                                RefObject<Integer> refObject = ires;
                                Integer n18 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 2) == 't' && res.charAt((Integer)ires.argvalue - 1) == 'y') {
                                res.setCharAt((Integer)ires.argvalue - 1, 't');
                                res.insert((int)((Integer)ires.argvalue), "y");
                                RefObject<Integer> refObject = ires;
                                Integer n19 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else if (res.charAt((Integer)ires.argvalue - 2) == 'z' && res.charAt((Integer)ires.argvalue - 1) == 's') {
                                res.setCharAt((Integer)ires.argvalue - 1, 'z');
                                res.insert((int)((Integer)ires.argvalue), "s");
                                RefObject<Integer> refObject = ires;
                                Integer n20 = (Integer)refObject.argvalue;
                                refObject.argvalue = (Integer)refObject.argvalue + 1;
                                object2 = refObject.argvalue;
                            } else {
                                char c = res.charAt((Integer)ires.argvalue - 1);
                                String s = "";
                                s = s + c;
                                res.insert((int)((Integer)ires.argvalue), s);
                                object2 = ires;
                                n = (Integer)((RefObject)object2).argvalue;
                                ((RefObject)object2).argvalue = (Integer)((RefObject)object2).argvalue + 1;
                                object = ((RefObject)object2).argvalue;
                            }
                        } else {
                            char c = res.charAt((Integer)ires.argvalue - 1);
                            String s = "";
                            s = s + c;
                            res.insert((int)((Integer)ires.argvalue), s);
                            object2 = ires;
                            n = (Integer)((RefObject)object2).argvalue;
                            ((RefObject)object2).argvalue = (Integer)((RefObject)object2).argvalue + 1;
                            object = ((RefObject)object2).argvalue;
                        }
                    }
                    if ((Integer)ires.argvalue == -1) {
                        res.insert(res.length(), "<INVALID CMD=" + commands.charAt(ic + 1) + ">");
                        ires.argvalue = res.length();
                        return res.toString();
                    }
                    ++ic;
                    while (ic < commands.length() && commands.charAt(ic) != '>') {
                        ++ic;
                    }
                    ++ic;
                    continue;
                }
                for (int i = 0; i < val; ++i) {
                    res.insert((int)((Integer)ires.argvalue), String.valueOf(res.charAt((Integer)ires.argvalue - val)));
                    RefObject<Integer> s = ires;
                    object2 = (Integer)s.argvalue;
                    s.argvalue = (Integer)s.argvalue + 1;
                    n = s.argvalue;
                }
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'E') {
                int val = Gram.argnum(commands, ic + 2);
                if (val != 1) {
                    res.insert((int)((Integer)ires.argvalue), "<E:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'L') {
                int val = Gram.argnum(commands, ic + 2);
                if (val == -1) {
                    RefObject<Integer> i = ires;
                    Integer s = (Integer)i.argvalue;
                    i.argvalue = (Integer)i.argvalue - 1;
                    object2 = i.argvalue;
                    while ((Integer)ires.argvalue >= 0 && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        i = ires;
                        s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue - 1;
                        object2 = i.argvalue;
                    }
                    i = ires;
                    s = (Integer)i.argvalue;
                    i.argvalue = (Integer)i.argvalue + 1;
                    object2 = i.argvalue;
                    ++ic;
                    while (ic < commands.length() && commands.charAt(ic) != '>') {
                        ++ic;
                    }
                    ++ic;
                    continue;
                }
                if (val == 0) {
                    res.insert((int)((Integer)ires.argvalue), "<L:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                if ((Integer)ires.argvalue - val < 0) {
                    res.insert((int)((Integer)ires.argvalue), "<L:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                RefObject<Integer> i = ires;
                Integer.valueOf((Integer)i.argvalue - val);
                i.argvalue = i.argvalue;
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'P') {
                int val = Gram.argnum(commands, ic + 2);
                if (val == -1) {
                    ires.argvalue = 0;
                    while ((Integer)ires.argvalue < res.length() && !Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        RefObject<Integer> i = ires;
                        Integer s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue + 1;
                        object2 = i.argvalue;
                    }
                    while ((Integer)ires.argvalue < res.length() && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        RefObject<Integer> i = ires;
                        Integer s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue + 1;
                        object2 = i.argvalue;
                    }
                    if ((Integer)ires.argvalue < res.length() && (Integer)ires.argvalue > 0) {
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    res.insert((int)((Integer)ires.argvalue), "<P:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                if (val == 0) {
                    res.insert((int)((Integer)ires.argvalue), "<P:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                while (val > 0) {
                    RefObject<Integer> i = ires;
                    Integer s = (Integer)i.argvalue;
                    i.argvalue = (Integer)i.argvalue - 1;
                    object2 = i.argvalue;
                    while ((Integer)ires.argvalue >= 0 && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        i = ires;
                        s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue - 1;
                        object2 = i.argvalue;
                    }
                    while ((Integer)ires.argvalue >= 0 && !Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        i = ires;
                        s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue - 1;
                        object2 = i.argvalue;
                    }
                    --val;
                }
                RefObject<Integer> i = ires;
                Integer s = (Integer)i.argvalue;
                i.argvalue = (Integer)i.argvalue + 1;
                object2 = i.argvalue;
                if ((Integer)ires.argvalue < 0) {
                    res.insert((int)((Integer)ires.argvalue), "<P:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'R') {
                int val = Gram.argnum(commands, ic + 2);
                if (val == -1) {
                    while ((Integer)ires.argvalue < res.length() && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        RefObject<Integer> i = ires;
                        Integer s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue + 1;
                        object2 = i.argvalue;
                    }
                    ++ic;
                    while (ic < commands.length() && commands.charAt(ic) != '>') {
                        ++ic;
                    }
                    ++ic;
                    continue;
                }
                if (val == 0) {
                    res.insert((int)((Integer)ires.argvalue), "<R:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                if ((Integer)ires.argvalue + val > res.length()) {
                    res.insert((int)((Integer)ires.argvalue), "<R:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                RefObject<Integer> i = ires;
                Integer.valueOf((Integer)i.argvalue + val);
                i.argvalue = i.argvalue;
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'N') {
                int val = Gram.argnum(commands, ic + 2);
                if (val == -1) {
                    ires.argvalue = res.length() - 1;
                    while ((Integer)ires.argvalue >= 0 && !Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        RefObject<Integer> i = ires;
                        Integer s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue - 1;
                        object2 = i.argvalue;
                    }
                    if ((Integer)ires.argvalue >= 0) {
                        RefObject<Integer> i = ires;
                        Integer s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue + 1;
                        object2 = i.argvalue;
                        ++ic;
                        while (ic < commands.length() && commands.charAt(ic) != '>') {
                            ++ic;
                        }
                        ++ic;
                        continue;
                    }
                    res.insert((int)((Integer)ires.argvalue), "<N:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                if (val == 0) {
                    res.insert((int)((Integer)ires.argvalue), "<N:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                while (val > 0) {
                    Integer s;
                    RefObject<Integer> i;
                    while ((Integer)ires.argvalue < res.length() && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        i = ires;
                        s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue + 1;
                        object2 = i.argvalue;
                    }
                    while ((Integer)ires.argvalue < res.length() && !Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        i = ires;
                        s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue + 1;
                        object2 = i.argvalue;
                    }
                    while ((Integer)ires.argvalue < res.length() && Language.isLetter(res.charAt((Integer)ires.argvalue))) {
                        i = ires;
                        s = (Integer)i.argvalue;
                        i.argvalue = (Integer)i.argvalue + 1;
                        object2 = i.argvalue;
                    }
                    --val;
                }
                if ((Integer)ires.argvalue > res.length()) {
                    res.insert((int)((Integer)ires.argvalue), "<N:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                    return res.toString();
                }
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (commands.charAt(ic + 1) == 'S') {
                int val = Gram.argnum(commands, ic + 2);
                if (val == -1) {
                    val = res.length() - (Integer)ires.argvalue;
                } else {
                    if (val == 0) {
                        res.insert((int)((Integer)ires.argvalue), "<S:UNKNOWN ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                    if ((Integer)ires.argvalue + val > res.length()) {
                        res.insert((int)((Integer)ires.argvalue), "<S:INVALID ARG=" + commands.charAt(ic + 2) + ">");
                        return res.toString();
                    }
                }
                res.delete((Integer)ires.argvalue, (Integer)ires.argvalue + val);
                ++ic;
                while (ic < commands.length() && commands.charAt(ic) != '>') {
                    ++ic;
                }
                ++ic;
                continue;
            }
            if (lan.isoName.equals("ar")) {
                if (commands.charAt(ic + 1) == 'T') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u0629') {
                        char c = '\u062a';
                        res.setCharAt((Integer)ires.argvalue - 1, c);
                    }
                } else if (commands.charAt(ic + 1) == 'M') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u0646') {
                        res.insert((int)((Integer)ires.argvalue), "\u0651");
                        ires.argvalue = (Integer)ires.argvalue + 1;
                    } else {
                        res.insert((int)((Integer)ires.argvalue), "\u0652");
                        res.insert((Integer)ires.argvalue + 1, '\u0646');
                        ires.argvalue = (Integer)ires.argvalue + 2;
                    }
                } else if (commands.charAt(ic + 1) == 'Z') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u062a') {
                        res.insert((int)((Integer)ires.argvalue), "\u0651");
                        ires.argvalue = (Integer)ires.argvalue + 1;
                    } else {
                        res.insert((int)((Integer)ires.argvalue), "\u0652");
                        res.insert((Integer)ires.argvalue + 1, "\u062a");
                        ires.argvalue = (Integer)ires.argvalue + 2;
                    }
                }
            } else if (lan.isoName.equals("tm")) {
                if (commands.charAt(ic + 1) == 'D') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u0263') {
                        res.setCharAt((Integer)ires.argvalue - 1, 'q');
                        res.insert((int)((Integer)ires.argvalue), "q");
                        RefObject<Integer> c = ires;
                        Integer s = (Integer)c.argvalue;
                        c.argvalue = (Integer)c.argvalue + 1;
                        object2 = c.argvalue;
                    } else if (res.charAt((Integer)ires.argvalue - 1) == '\u1e0d') {
                        res.setCharAt((Integer)ires.argvalue - 1, '\u1e6d');
                        res.insert((int)((Integer)ires.argvalue), "\u1e6d");
                        RefObject<Integer> c = ires;
                        Integer s = (Integer)c.argvalue;
                        c.argvalue = (Integer)c.argvalue + 1;
                        object2 = c.argvalue;
                    } else {
                        char c = res.charAt((Integer)ires.argvalue - 1);
                        String s = "";
                        s = s + c;
                        res.insert((int)((Integer)ires.argvalue), s);
                        object2 = ires;
                        n = (Integer)((RefObject)object2).argvalue;
                        ((RefObject)object2).argvalue = (Integer)((RefObject)object2).argvalue + 1;
                        object = ((RefObject)object2).argvalue;
                    }
                } else if (commands.charAt(ic + 1) == 'T') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u1e0d') {
                        res.setCharAt((Integer)ires.argvalue - 1, '\u1e6d');
                    } else {
                        res.insert((int)((Integer)ires.argvalue), "t");
                        RefObject<Integer> c = ires;
                        Integer s = (Integer)c.argvalue;
                        c.argvalue = (Integer)c.argvalue + 1;
                        object2 = c.argvalue;
                    }
                    res.insert(0, 't');
                    RefObject<Integer> c = ires;
                    Integer s = (Integer)c.argvalue;
                    c.argvalue = (Integer)c.argvalue + 1;
                    object2 = c.argvalue;
                } else if (commands.charAt(ic + 1) == 'A') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt(0) == 'a') {
                        if (res.length() > 2 && (res.charAt(2) == 'a' || res.charAt(2) == 'e' || res.charAt(2) == 'i' || res.charAt(2) == 'u')) {
                            res.setCharAt(0, 'u');
                        } else {
                            res.setCharAt(0, 'e');
                            res.insert(0, 'w');
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        }
                    } else if (res.charAt(0) == 'i') {
                        if (res.length() > 2 && (res.charAt(2) == 'a' || res.charAt(2) == 'e' || res.charAt(2) == 'i' || res.charAt(2) == 'u')) {
                            res.setCharAt(0, 'i');
                        } else {
                            res.setCharAt(0, 'e');
                            res.insert(0, 'y');
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        }
                    } else if (res.charAt(0) == 'u') {
                        res.insert(0, 'w');
                        RefObject<Integer> c = ires;
                        Integer s = (Integer)c.argvalue;
                        c.argvalue = (Integer)c.argvalue + 1;
                        object2 = c.argvalue;
                    } else if (res.charAt(0) == 't' && res.length() > 1 && (res.charAt(1) == 'a' || res.charAt(1) == 'i')) {
                        if (res.length() > 3 && (res.charAt(3) == 'a' || res.charAt(3) == 'e' || res.charAt(3) == 'i' || res.charAt(3) == 'u')) {
                            res.delete(1, 1);
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue - 1;
                            object2 = c.argvalue;
                        } else {
                            res.setCharAt(1, 'e');
                        }
                    }
                }
            } else if (lan.isoName.equals("hu")) {
                if (commands.charAt(ic + 1) == '\u00c1') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == 'a') {
                        res.setCharAt((Integer)ires.argvalue - 1, '\u00e1');
                    } else if (res.charAt((Integer)ires.argvalue - 1) == 'e') {
                        res.setCharAt((Integer)ires.argvalue - 1, '\u00e9');
                    }
                } else if (commands.charAt(ic + 1) == 'D') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) != 'b' || (Integer)ires.argvalue < 2 || res.charAt((Integer)ires.argvalue - 2) != res.charAt((Integer)ires.argvalue - 1)) {
                        if (res.charAt((Integer)ires.argvalue - 1) == 'a' || res.charAt((Integer)ires.argvalue - 1) == '\u00e1') {
                            res.setCharAt((Integer)ires.argvalue - 1, '\u00e1');
                            res.insert((int)((Integer)ires.argvalue), "v");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 1) == 'e' || res.charAt((Integer)ires.argvalue - 1) == '\u00e9') {
                            res.setCharAt((Integer)ires.argvalue - 1, '\u00e9');
                            res.insert((int)((Integer)ires.argvalue), "v");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 1) == 'x') {
                            res.setCharAt((Integer)ires.argvalue - 1, 'x');
                            res.insert((int)((Integer)ires.argvalue), "s");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                            res.insert((int)((Integer)ires.argvalue), "z");
                            c = ires;
                            s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 1) == 'i' || res.charAt((Integer)ires.argvalue - 1) == '\u00ed' || res.charAt((Integer)ires.argvalue - 1) == 'o' || res.charAt((Integer)ires.argvalue - 1) == '\u00f3' || res.charAt((Integer)ires.argvalue - 1) == '\u00f6' || res.charAt((Integer)ires.argvalue - 1) == '\u0151' || res.charAt((Integer)ires.argvalue - 1) == 'u' || res.charAt((Integer)ires.argvalue - 1) == '\u00fa' || res.charAt((Integer)ires.argvalue - 1) == '\u00fc' || res.charAt((Integer)ires.argvalue - 1) == '\u0171') {
                            res.insert((int)((Integer)ires.argvalue), "v");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (!((Integer)ires.argvalue < 3 || res.charAt((Integer)ires.argvalue - 3) == 'c' && res.charAt((Integer)ires.argvalue - 2) == 'c' && res.charAt((Integer)ires.argvalue - 1) == 's' || res.charAt((Integer)ires.argvalue - 3) == 'g' && res.charAt((Integer)ires.argvalue - 2) == 'g' && res.charAt((Integer)ires.argvalue - 1) == 'y' || res.charAt((Integer)ires.argvalue - 3) == 'l' && res.charAt((Integer)ires.argvalue - 2) == 'l' && res.charAt((Integer)ires.argvalue - 1) == 'y' || res.charAt((Integer)ires.argvalue - 3) == 'n' && res.charAt((Integer)ires.argvalue - 2) == 'n' && res.charAt((Integer)ires.argvalue - 1) == 'y' || res.charAt((Integer)ires.argvalue - 3) == 't' && res.charAt((Integer)ires.argvalue - 2) == 't' && res.charAt((Integer)ires.argvalue - 1) == 'y' || res.charAt((Integer)ires.argvalue - 3) == 's' && res.charAt((Integer)ires.argvalue - 2) == 's' && res.charAt((Integer)ires.argvalue - 1) == 'z' || res.charAt((Integer)ires.argvalue - 3) == 'z' && res.charAt((Integer)ires.argvalue - 2) == 'z' && res.charAt((Integer)ires.argvalue - 1) == 's' || res.charAt((Integer)ires.argvalue - 3) != 'd' || res.charAt((Integer)ires.argvalue - 2) != 'z' || res.charAt((Integer)ires.argvalue - 1) != 's')) {
                            res.setCharAt((Integer)ires.argvalue - 2, 'd');
                            res.setCharAt((Integer)ires.argvalue - 1, 'z');
                            res.insert((int)((Integer)ires.argvalue), "s");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        }
                    }
                    if ((Integer)ires.argvalue >= 2) {
                        if (res.charAt((Integer)ires.argvalue - 2) == 'c' && res.charAt((Integer)ires.argvalue - 1) == 's') {
                            res.setCharAt((Integer)ires.argvalue - 1, 'c');
                            res.insert((int)((Integer)ires.argvalue), "s");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 2) == 'd' && res.charAt((Integer)ires.argvalue - 1) == 'z') {
                            res.setCharAt((Integer)ires.argvalue - 1, 'd');
                            res.insert((int)((Integer)ires.argvalue), "z");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 2) == 'g' && res.charAt((Integer)ires.argvalue - 1) == 'y') {
                            res.setCharAt((Integer)ires.argvalue - 1, 'g');
                            res.insert((int)((Integer)ires.argvalue), "y");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 2) == 'l' && res.charAt((Integer)ires.argvalue - 1) == 'y') {
                            res.setCharAt((Integer)ires.argvalue - 1, 'l');
                            res.insert((int)((Integer)ires.argvalue), "y");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 2) == 'n' && res.charAt((Integer)ires.argvalue - 1) == 'y') {
                            res.setCharAt((Integer)ires.argvalue - 1, 'n');
                            res.insert((int)((Integer)ires.argvalue), "y");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 2) == 's' && res.charAt((Integer)ires.argvalue - 1) == 'z') {
                            res.setCharAt((Integer)ires.argvalue - 1, 's');
                            res.insert((int)((Integer)ires.argvalue), "z");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 2) == 't' && res.charAt((Integer)ires.argvalue - 1) == 'y') {
                            res.setCharAt((Integer)ires.argvalue - 1, 't');
                            res.insert((int)((Integer)ires.argvalue), "y");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else if (res.charAt((Integer)ires.argvalue - 2) == 'z' && res.charAt((Integer)ires.argvalue - 1) == 's') {
                            res.setCharAt((Integer)ires.argvalue - 1, 'z');
                            res.insert((int)((Integer)ires.argvalue), "s");
                            RefObject<Integer> c = ires;
                            Integer s = (Integer)c.argvalue;
                            c.argvalue = (Integer)c.argvalue + 1;
                            object2 = c.argvalue;
                        } else {
                            char c = res.charAt((Integer)ires.argvalue - 1);
                            String s = "";
                            s = s + c;
                            res.insert((int)((Integer)ires.argvalue), s);
                            object2 = ires;
                            n = (Integer)((RefObject)object2).argvalue;
                            ((RefObject)object2).argvalue = (Integer)((RefObject)object2).argvalue + 1;
                            object = ((RefObject)object2).argvalue;
                        }
                    } else {
                        char c = res.charAt((Integer)ires.argvalue - 1);
                        String s = "";
                        s = s + c;
                        res.insert((int)((Integer)ires.argvalue), s);
                        object2 = ires;
                        n = (Integer)((RefObject)object2).argvalue;
                        ((RefObject)object2).argvalue = (Integer)((RefObject)object2).argvalue + 1;
                        object = ((RefObject)object2).argvalue;
                    }
                }
            } else if (lan.isoName.equals("qu")) {
                if (commands.charAt(ic + 1) == 'Q') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    int ires0 = (Integer)ires.argvalue;
                    for (int j = 0; j < ires0; ++j) {
                        char c = res.charAt(j);
                        String s = "";
                        s = s + c;
                        res.insert((int)((Integer)ires.argvalue), s);
                        object = ires;
                        Integer n21 = (Integer)((RefObject)object).argvalue;
                        ((RefObject)object).argvalue = (Integer)((RefObject)object).argvalue + 1;
                        Integer n22 = ((RefObject)object).argvalue;
                    }
                }
            } else if (lan.isoName.equals("sp")) {
                if (commands.charAt(ic + 1) == 'U') {
                    int j;
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    for (j = (Integer)ires.argvalue - 1; j >= 0 && res.charAt(j) != 'e' && res.charAt(j) != 'E' && res.charAt(j) != 'o' && res.charAt(j) != 'O'; --j) {
                    }
                    if (j >= 0) {
                        if (res.charAt(j) == 'e') {
                            res.insert(j, 'i');
                        } else if (res.charAt(j) == 'E') {
                            res.insert(j, 'I');
                        } else if (res.charAt(j) == 'o') {
                            res.setCharAt(j, 'e');
                            res.insert(j, 'u');
                        } else if (res.charAt(j) == 'O') {
                            res.setCharAt(j, 'E');
                            res.insert(j, 'U');
                        }
                        RefObject<Integer> refObject = ires;
                        object2 = (Integer)refObject.argvalue;
                        refObject.argvalue = (Integer)refObject.argvalue + 1;
                        n = refObject.argvalue;
                    }
                } else if (commands.charAt(ic + 1) == 'V') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    for (int j = (Integer)ires.argvalue - 1; j >= 0; --j) {
                        if (j < 0) continue;
                        if (res.charAt(j) == 'e') {
                            res.setCharAt(j, 'i');
                            continue;
                        }
                        if (res.charAt(j) == 'E') {
                            res.setCharAt(j, 'I');
                            continue;
                        }
                        if (res.charAt(j) == 'o') {
                            res.setCharAt(j, 'u');
                            continue;
                        }
                        if (res.charAt(j) == 'O') {
                            res.setCharAt(j, 'U');
                            continue;
                        }
                        if (res.charAt(j) == 'z') {
                            res.setCharAt(j, 'c');
                            continue;
                        }
                        if (res.charAt(j) == 'Z') {
                            res.setCharAt(j, 'C');
                            continue;
                        }
                        if (res.charAt(j) == 'u') {
                            res.setCharAt(j, '\u00fc');
                            continue;
                        }
                        if (res.charAt(j) == 'U') {
                            res.setCharAt(j, '\u00dc');
                            continue;
                        }
                        if (res.charAt(j) == 'g') {
                            res.setCharAt(j, 'j');
                            continue;
                        }
                        if (res.charAt(j) == 'G') {
                            res.setCharAt(j, 'J');
                            continue;
                        }
                        if (res.charAt(j) == 'c') {
                            res.setCharAt(j, 'z');
                            continue;
                        }
                        if (res.charAt(j) != 'C') continue;
                        res.setCharAt(j, 'Z');
                    }
                } else if (commands.charAt(ic + 1) == '\u00c1') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                } else if (commands.charAt(ic + 1) == '\u00c0') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                } else if (commands.charAt(ic + 1) == '\u00c2') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                } else if (commands.charAt(ic + 1) == '\u00c4') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                } else if (commands.charAt(ic + 1) == 'I' && (Integer)ires.argvalue - 1 < 0) {
                    ires.argvalue = -1;
                }
            } else if (lan.isoName.equals("ca") || lan.isoName.equals("de") || lan.isoName.equals("el") || lan.isoName.equals("gl") || lan.isoName.equals("it") || lan.isoName.equals("pt") || lan.isoName.equals("rr")) {
                if (commands.charAt(ic + 1) == '\u00c1') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                } else if (commands.charAt(ic + 1) == '\u00c0') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                } else if (commands.charAt(ic + 1) == '\u00c2') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                } else if (commands.charAt(ic + 1) == '\u00c4') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                } else if (commands.charAt(ic + 1) == 'I' && (Integer)ires.argvalue - 1 < 0) {
                    ires.argvalue = -1;
                }
            } else if (lan.isoName.equals("he")) {
                if (commands.charAt(ic + 1) == 'F') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u05b0' && res.charAt((Integer)ires.argvalue - 2) == '\u05da') {
                        res.setCharAt((Integer)ires.argvalue - 2, '\u05db');
                        res.delete((Integer)ires.argvalue - 1, 1);
                        RefObject<Integer> refObject = ires;
                        Integer n23 = (Integer)refObject.argvalue;
                        refObject.argvalue = (Integer)refObject.argvalue - 1;
                        object2 = refObject.argvalue;
                    } else if (res.charAt((Integer)ires.argvalue - 1) == '\u05db') {
                        if ((Integer)ires.argvalue - 1 < 0) {
                            ires.argvalue = -1;
                        }
                        res.setCharAt((Integer)ires.argvalue - 1, '\u05da');
                        res.insert((int)((Integer)ires.argvalue), "");
                        RefObject<Integer> refObject = ires;
                        Integer n24 = (Integer)refObject.argvalue;
                        refObject.argvalue = (Integer)refObject.argvalue + 1;
                        object2 = refObject.argvalue;
                    } else {
                        if ((Integer)ires.argvalue - 1 < 0) {
                            ires.argvalue = -1;
                        }
                        res.setCharAt((Integer)ires.argvalue - 1, Language.finalize(res.charAt((Integer)ires.argvalue - 1)));
                    }
                } else if (commands.charAt(ic + 1) == 'G') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u05d1' || res.charAt((Integer)ires.argvalue - 1) == '\u05d2' || res.charAt((Integer)ires.argvalue - 1) == '\u05d3' || res.charAt((Integer)ires.argvalue - 1) == '\u05db' || res.charAt((Integer)ires.argvalue - 1) == '\u05e4' || res.charAt((Integer)ires.argvalue - 1) == '\u05ea') {
                        res.insert((int)((Integer)ires.argvalue), "");
                        RefObject<Integer> refObject = ires;
                        Integer n25 = (Integer)refObject.argvalue;
                        refObject.argvalue = (Integer)refObject.argvalue + 1;
                        object2 = refObject.argvalue;
                    }
                } else if (commands.charAt(ic + 1) == 'H') {
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u05d0' || res.charAt((Integer)ires.argvalue - 1) == '\u05d4' || res.charAt((Integer)ires.argvalue - 1) == '\u05d7' || res.charAt((Integer)ires.argvalue - 1) == '\u05e2') {
                        res.insert((int)((Integer)ires.argvalue), "");
                    } else {
                        res.insert((int)((Integer)ires.argvalue), "");
                    }
                    ires.argvalue = (Integer)ires.argvalue + 1;
                } else if (commands.charAt(ic + 1) == 'M') {
                    RefObject<Integer> refObject;
                    if ((Integer)ires.argvalue - 1 < 0) {
                        ires.argvalue = -1;
                    }
                    if (res.charAt((Integer)ires.argvalue - 1) == '\u05c1' || res.charAt((Integer)ires.argvalue - 1) == '\u05c2') {
                        refObject = ires;
                        Integer.valueOf((Integer)refObject.argvalue - 2);
                        refObject.argvalue = refObject.argvalue;
                        res.delete((Integer)ires.argvalue, 2);
                    } else if ((Integer)ires.argvalue >= 2 && res.charAt((Integer)ires.argvalue - 2) == '\u05bc') {
                        refObject = ires;
                        Integer.valueOf((Integer)refObject.argvalue - 2);
                        refObject.argvalue = refObject.argvalue;
                        res.delete((Integer)ires.argvalue, 2);
                    } else {
                        refObject = ires;
                        Integer n26 = (Integer)refObject.argvalue;
                        refObject.argvalue = (Integer)refObject.argvalue - 1;
                        object2 = refObject.argvalue;
                        res.delete((Integer)ires.argvalue, 1);
                    }
                    ++ic;
                    while (ic < commands.length() && commands.charAt(ic) != '>') {
                        ++ic;
                    }
                    ++ic;
                }
            } else {
                ires.argvalue = -1;
            }
            if ((Integer)ires.argvalue == -1) {
                res.insert(res.length(), "<INVALID CMD=" + commands.charAt(ic + 1) + ">");
                ires.argvalue = res.length();
                return res.toString();
            }
            ++ic;
            while (ic < commands.length() && commands.charAt(ic) != '>') {
                ++ic;
            }
            ++ic;
        }
        return res.toString();
    }

    private boolean alreadyInSols(ArrayList<String> sols, String newInput, String newOutput) {
        for (int i = 0; i < sols.size(); i += 2) {
            String cOutput;
            String cInput = sols.get(i);
            if (!newInput.equals(cInput) || !newOutput.equals(cOutput = sols.get(i + 1))) continue;
            return true;
        }
        return false;
    }

    private Date getMaxDate() {
        Calendar c = Calendar.getInstance();
        c.set(9999, 11, 31, 23, 59, 59);
        c.set(14, 999);
        Date maxDate = c.getTime();
        return maxDate;
    }

    public final String[] generateParaphrases(int recLevel, HashMap<String, Gram> allGrammars, int matchLimit, Date dateLimit, GramType gt, Language lan, boolean keepVariables) {
        ArrayList<String> sols = null;
        Stack<MTrace> stack = new Stack<MTrace>();
        stack.push(new MTrace());
        block0: while (stack.size() > 0) {
            MTrace curTrc = (MTrace)stack.pop();
            State state = this.states.get(curTrc.Statenb);
            for (int itrans = 0; itrans < state.Dests.size(); ++itrans) {
                Date dt = new Date();
                Date maxDate = this.getMaxDate();
                if (!dateLimit.equals(maxDate) && dt.compareTo(dateLimit) > 0) break block0;
                int dst = state.Dests.get(itrans);
                int lbl = state.IdLabels.get(itrans);
                String label = this.prepareVocabIn(lbl);
                String labelOut = this.prepareVocabOut(lbl);
                MTrace newTrc = new MTrace();
                newTrc.Statenb = dst;
                newTrc.Inputs.addAll(curTrc.Inputs);
                newTrc.Outputs.addAll(curTrc.Outputs);
                if (recLevel != -1 && label.length() > 0 && label.charAt(0) == ':') {
                    String[] recSols;
                    Gram rgrm;
                    if (allGrammars == null || (rgrm = allGrammars.get(label.substring(1))) == null || (recSols = rgrm.generateParaphrases(recLevel + 1, allGrammars, matchLimit, dateLimit, gt, lan, keepVariables)) == null) continue;
                    if (recSols.length == 2) {
                        newTrc.Inputs.add(recSols[0]);
                        newTrc.Outputs.add(recSols[1]);
                        if (labelOut != null) {
                            if (gt == GramType.FLX) {
                                if (labelOut.charAt(0) == '+') {
                                    newTrc.Outputs.add(labelOut);
                                } else {
                                    newTrc.Outputs.add("+" + labelOut);
                                }
                            } else {
                                newTrc.Outputs.add(labelOut);
                            }
                        }
                        stack.push(newTrc);
                        if (dst != 1) continue;
                        String newInput = null;
                        if (newTrc.Inputs.size() > 0) {
                            StringBuilder totalInput = new StringBuilder(newTrc.Inputs.get(0));
                            for (int i = 1; i < newTrc.Inputs.size(); ++i) {
                                if (gt == GramType.SYNTAX) {
                                    totalInput.append(' ');
                                }
                                totalInput.append(newTrc.Inputs.get(i));
                            }
                            newInput = totalInput.toString();
                        } else {
                            newInput = "";
                        }
                        String newOutput = null;
                        if (newTrc.Outputs.size() > 0) {
                            StringBuilder totalOutput = new StringBuilder(newTrc.Outputs.get(0));
                            for (int i = 1; i < newTrc.Outputs.size(); ++i) {
                                totalOutput.append(newTrc.Outputs.get(i));
                            }
                            newOutput = totalOutput.toString();
                        } else {
                            newOutput = "";
                        }
                        if (sols == null) {
                            sols = new ArrayList();
                        }
                        if (!(matchLimit != -1 && sols.size() >= matchLimit * 2 || this.alreadyInSols(sols, newInput, newOutput))) {
                            sols.add(newInput);
                            sols.add(newOutput);
                        }
                        if (recLevel >= 2 || matchLimit <= 0 || sols.size() <= matchLimit * 2) continue;
                        break block0;
                    }
                    if (recSols.length <= 2) continue;
                    for (int irec = 0; irec < recSols.length; irec += 2) {
                        MTrace newTrc0 = new MTrace();
                        newTrc0.Statenb = newTrc.Statenb;
                        newTrc0.Pos = newTrc.Pos;
                        newTrc0.Inputs.addAll(newTrc.Inputs);
                        newTrc0.Outputs.addAll(newTrc.Outputs);
                        newTrc0.Inputs.add(recSols[irec]);
                        newTrc0.Outputs.add(recSols[irec + 1]);
                        if (labelOut != null) {
                            if (gt == GramType.FLX) {
                                if (labelOut.length() > 0 && labelOut.charAt(0) == '+') {
                                    newTrc.Outputs.add(labelOut);
                                } else if (labelOut.length() > 0) {
                                    newTrc.Outputs.add("+" + labelOut);
                                }
                            } else if (gt == GramType.MORPHO) {
                                if (labelOut.length() > 0 && labelOut.charAt(0) == '+') {
                                    newTrc.Outputs.add(labelOut);
                                } else {
                                    String ilab;
                                    int iout;
                                    for (iout = 0; iout < newTrc.Outputs.size() && ((ilab = newTrc.Outputs.get(iout)).length() <= 0 || ilab.charAt(0) != '+'); ++iout) {
                                    }
                                    if (iout < newTrc.Outputs.size()) {
                                        newTrc.Outputs.add(iout, labelOut);
                                    } else {
                                        newTrc.Outputs.add(labelOut);
                                    }
                                }
                            } else {
                                newTrc.Outputs.add(labelOut);
                            }
                        }
                        stack.push(newTrc0);
                        if (dst != 1) continue;
                        String newInput = null;
                        if (newTrc0.Inputs.size() > 0) {
                            StringBuilder totalInput = new StringBuilder(newTrc0.Inputs.get(0));
                            for (int i = 1; i < newTrc0.Inputs.size(); ++i) {
                                if (gt == GramType.SYNTAX) {
                                    totalInput.append(' ');
                                }
                                totalInput.append(newTrc0.Inputs.get(i));
                            }
                            newInput = totalInput.toString();
                        } else {
                            newInput = "";
                        }
                        String newOutput = null;
                        if (newTrc0.Outputs.size() > 0) {
                            StringBuilder totalOutput = new StringBuilder(newTrc0.Outputs.get(0));
                            for (int i = 1; i < newTrc0.Outputs.size(); ++i) {
                                totalOutput.append(newTrc0.Outputs.get(i));
                            }
                            newOutput = totalOutput.toString();
                        } else {
                            newOutput = "";
                        }
                        if (sols == null) {
                            sols = new ArrayList();
                        }
                        if (!(matchLimit != -1 && sols.size() >= matchLimit * 2 || this.alreadyInSols(sols, newInput, newOutput))) {
                            sols.add(newInput);
                            sols.add(newOutput);
                        }
                        if (recLevel < 2 && matchLimit > 0 && sols.size() >= matchLimit * 2) break block0;
                    }
                    continue;
                }
                if (!label.equals("<E>") && label != null && !label.equals("")) {
                    if (gt == GramType.SYNTAX) {
                        if (label.length() >= 2 && label.charAt(0) == '$' && (label.charAt(1) == '(' || label.charAt(1) == ')')) {
                            if (keepVariables) {
                                newTrc.Inputs.add(" " + label);
                            }
                        } else {
                            newTrc.Inputs.add(" " + label);
                        }
                    } else {
                        newTrc.Inputs.add(label);
                    }
                }
                if (labelOut != null && labelOut.length() > 0) {
                    if (gt == GramType.FLX) {
                        if (labelOut.charAt(0) == '+') {
                            newTrc.Outputs.add(labelOut);
                        } else {
                            newTrc.Outputs.add("+" + labelOut);
                        }
                    } else if (gt == GramType.MORPHO) {
                        if (labelOut.length() > 0 && labelOut.charAt(0) == '+') {
                            newTrc.Outputs.add(labelOut);
                        } else {
                            String ilab;
                            int iout;
                            for (iout = 0; iout < newTrc.Outputs.size() && ((ilab = newTrc.Outputs.get(iout)).length() <= 0 || ilab.charAt(0) != '+'); ++iout) {
                            }
                            if (iout < newTrc.Outputs.size()) {
                                newTrc.Outputs.add(iout, labelOut);
                            } else {
                                newTrc.Outputs.add(labelOut);
                            }
                        }
                    } else {
                        newTrc.Outputs.add(labelOut);
                    }
                }
                stack.push(newTrc);
                if (dst != 1) continue;
                String newInput = null;
                if (newTrc.Inputs.size() > 0) {
                    StringBuilder totalInput = new StringBuilder(newTrc.Inputs.get(0));
                    for (int i = 1; i < newTrc.Inputs.size(); ++i) {
                        if (gt == GramType.SYNTAX) {
                            totalInput.append(' ');
                        }
                        totalInput.append(newTrc.Inputs.get(i));
                    }
                    newInput = totalInput.toString();
                } else {
                    newInput = "";
                }
                String newoutput = null;
                if (newTrc.Outputs.size() > 0) {
                    StringBuilder totaloutput = new StringBuilder(newTrc.Outputs.get(0));
                    for (int i = 1; i < newTrc.Outputs.size(); ++i) {
                        totaloutput.append(newTrc.Outputs.get(i));
                    }
                    newoutput = totaloutput.toString();
                } else {
                    newoutput = "";
                }
                if (sols == null) {
                    sols = new ArrayList<String>();
                }
                if (!(matchLimit != -1 && sols.size() >= matchLimit * 2 || this.alreadyInSols(sols, newInput, newoutput))) {
                    sols.add(newInput);
                    sols.add(newoutput);
                }
                if (recLevel < 2 && matchLimit > 0 && sols.size() >= matchLimit * 2) break block0;
            }
        }
        if (sols != null && sols.size() > 0) {
            String[] forms = sols.toArray(new String[sols.size()]);
            for (int iform = 0; iform < forms.length; ++iform) {
                if (forms[iform] == null) continue;
                forms[iform] = forms[iform].trim();
            }
            return forms;
        }
        return null;
    }

    private String[] inflect(HashMap<String, Gram> allGrammars) {
        ArrayList<String> sols = null;
        Stack<MTrace> stack = new Stack<MTrace>();
        stack.push(new MTrace());
        while (stack.size() > 0) {
            MTrace curTrc = (MTrace)stack.pop();
            State state = this.states.get(curTrc.Statenb);
            for (int itrans = 0; itrans < state.Dests.size(); ++itrans) {
                int i;
                int dst = state.Dests.get(itrans);
                int lbl = state.IdLabels.get(itrans);
                String label = this.prepareVocabIn(lbl);
                String labelOut = this.prepareVocabOut(lbl);
                MTrace newTrc = new MTrace();
                newTrc.Statenb = dst;
                newTrc.Inputs.addAll(curTrc.Inputs);
                newTrc.Outputs.addAll(curTrc.Outputs);
                if (label.length() > 0 && label.charAt(0) == ':') {
                    Gram rGrm;
                    if (allGrammars == null || (rGrm = allGrammars.get(label.substring(1))) == null) continue;
                    String[] recSols = rGrm.inflect(allGrammars);
                    if (recSols.length == 2) {
                        int i2;
                        newTrc.Inputs.add(recSols[0]);
                        newTrc.Outputs.add(recSols[1]);
                        if (labelOut != null) {
                            if (labelOut.charAt(0) == '+') {
                                newTrc.Outputs.add(labelOut);
                            } else {
                                newTrc.Outputs.add("+" + labelOut);
                            }
                        }
                        stack.push(newTrc);
                        if (dst != 1) continue;
                        if (sols == null) {
                            sols = new ArrayList();
                        }
                        String totalInput = "";
                        String totalOutput = "";
                        for (i2 = 0; i2 < newTrc.Inputs.size(); ++i2) {
                            totalInput = totalInput + newTrc.Inputs.get(i2);
                        }
                        for (i2 = 0; i2 < newTrc.Outputs.size(); ++i2) {
                            totalOutput = totalOutput + newTrc.Outputs.get(i2);
                        }
                        sols.add(totalInput);
                        sols.add(totalOutput);
                        continue;
                    }
                    if (recSols.length <= 2) continue;
                    for (int irec = 0; irec < recSols.length; irec += 2) {
                        int i3;
                        MTrace newTrc0 = new MTrace();
                        newTrc0.Statenb = newTrc.Statenb;
                        newTrc0.Pos = newTrc.Pos;
                        newTrc0.Inputs.addAll(newTrc.Inputs);
                        newTrc0.Outputs.addAll(newTrc.Outputs);
                        newTrc0.Inputs.add(recSols[irec]);
                        newTrc0.Outputs.add(recSols[irec + 1]);
                        if (labelOut != null) {
                            if (labelOut.charAt(0) == '+') {
                                newTrc0.Outputs.add(labelOut);
                            } else {
                                newTrc0.Outputs.add("+" + labelOut);
                            }
                        }
                        stack.push(newTrc0);
                        if (dst != 1) continue;
                        if (sols == null) {
                            sols = new ArrayList();
                        }
                        String totalInput = "";
                        String totalOutput = "";
                        for (i3 = 0; i3 < newTrc0.Inputs.size(); ++i3) {
                            totalInput = totalInput + newTrc0.Inputs.get(i3);
                        }
                        for (i3 = 0; i3 < newTrc0.Outputs.size(); ++i3) {
                            totalOutput = totalOutput + newTrc0.Outputs.get(i3);
                        }
                        sols.add(totalInput);
                        sols.add(totalOutput);
                    }
                    continue;
                }
                if (!label.equals("<E>")) {
                    newTrc.Inputs.add(label);
                }
                if (labelOut != null && labelOut.length() > 0) {
                    if (labelOut.charAt(0) == '+') {
                        newTrc.Outputs.add(labelOut);
                    } else {
                        newTrc.Outputs.add("+" + labelOut);
                    }
                }
                stack.push(newTrc);
                if (dst != 1) continue;
                if (sols == null) {
                    sols = new ArrayList<String>();
                }
                String totalInput = "";
                String totalOutput = "";
                for (i = 0; i < newTrc.Inputs.size(); ++i) {
                    totalInput = totalInput + newTrc.Inputs.get(i);
                }
                for (i = 0; i < newTrc.Outputs.size(); ++i) {
                    totalOutput = totalOutput + newTrc.Outputs.get(i);
                }
                sols.add(totalInput);
                sols.add(totalOutput);
            }
        }
        if (sols != null && sols.size() > 0) {
            return sols.toArray(new String[sols.size()]);
        }
        return null;
    }

    public final void inflect(Language lan, String word, RefObject<String[]> forms, RefObject<String[]> outputs, HashMap<String, Gram> allGrammars) {
        forms.argvalue = null;
        outputs.argvalue = null;
        if (this.InflectionsCommands == null) {
            this.InflectionsCommands = this.inflect(allGrammars);
            this.cleanup();
        }
        if (this.InflectionsCommands == null) {
            return;
        }
        int pos = 0;
        forms.argvalue = new String[this.InflectionsCommands.length / 2];
        outputs.argvalue = new String[this.InflectionsCommands.length / 2];
        for (int i = 0; i < this.InflectionsCommands.length; i += 2) {
            RefObject<Integer> tempRef_pos = new RefObject<Integer>(pos);
            ((String[])forms.argvalue)[i / 2] = Gram.processInflection(lan, word, this.InflectionsCommands[i], tempRef_pos);
            pos = (Integer)tempRef_pos.argvalue;
            ((String[])outputs.argvalue)[i / 2] = this.InflectionsCommands[i + 1].length() > 0 && this.InflectionsCommands[i + 1].charAt(0) == '+' ? this.InflectionsCommands[i + 1] : "+" + this.InflectionsCommands[i + 1];
            if (!((String[])outputs.argvalue)[i / 2].equals("+<E>")) continue;
            ((String[])outputs.argvalue)[i / 2] = "";
        }
    }
}

